<# :
@echo off
cd /d "%~dp0"
:: The following line runs itself as PowerShell (-ExecutionPolicy Bypass to avoid permission errors)
powershell -NoProfile -ExecutionPolicy Bypass -Command "Invoke-Expression ((Get-Content '%~f0') -join [Environment]::NewLine)"
goto :eof
#>

# -------------------------------------------------------
# Please write your PowerShell (.ps1) code below here.
# -------------------------------------------------------

$ErrorActionPreference = "Stop"

$BASE = "$env:USERPROFILE\SHARP"
$DESKTOP = [Environment]::GetFolderPath("Desktop")
$SHORTCUT = "$DESKTOP\SHARP (Drag & Drop).lnk"

# ===============================
# Confirmation Dialog
# ===============================
Add-Type -AssemblyName PresentationFramework
$result = [System.Windows.MessageBox]::Show(
    "Do you want to completely uninstall SHARP? `n (All settings, environment, and output data will be deleted)",
    "SHARP Uninstall",
    "YesNo",
    "Warning"
)

if ($result -ne "Yes") {
    Write-Host "Cancelled"
    exit
}

# ===============================
# Delete Shortcut
# ===============================
if (Test-Path $SHORTCUT) {
    Remove-Item $SHORTCUT -Force
}

# ===============================
# SHARP Main Unit Removal
# ===============================
if (Test-Path $BASE) {
    Remove-Item $BASE -Recurse -Force
}

# ===============================
# Completion message
# ===============================
[System.Windows.MessageBox]::Show(
    "SHARP has been successfully uninstalled.",
    "SHARP"
)
